/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.artifact.internal;

import java.util.Collection;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.ui.hyperlink.HyperlinkUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public abstract class ArtifactReferenceHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String HTML_TARGET_ID = "org.eclipse.wst.html.core.htmlsource";
    private static final String XML_TARGET_ID = "org.eclipse.core.runtime.xml";

    protected IHyperlink[] doDetectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IStructuredModel structuredModel = null;
        try {
            IFile baseFile;
            ArtifactController controller = ArtifactControllerFactory.getController();
            IModelManager mgr = StructuredModelManager.getModelManager();
            if (mgr != null && (structuredModel = mgr.getExistingModelForRead(textViewer.getDocument())) != null && (baseFile = this.getBaseFile(structuredModel)) != null) {
                boolean hasCompatibleHyperlinks = HyperlinkUtil.hasCompatibleHyperlinks(this, textViewer, region, canShowMultipleHyperlinks);
                ResourceArtifact baseArtifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)baseFile);
                IHyperlink[] iHyperlinkArray = HyperlinkUtil.getLinksFromArtifact(baseFile, (IArtifact)baseArtifact, region.getOffset(), structuredModel, null, controller, hasCompatibleHyperlinks);
                return iHyperlinkArray;
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        return null;
    }

    private IFile getBaseFile(IStructuredModel structuredModel) {
        IFile file;
        String modelBaseLocation = structuredModel.getBaseLocation();
        Path path = new Path(modelBaseLocation);
        if (path.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
            return file;
        }
        return null;
    }

    public static class HTMLDetector
    extends ArtifactReferenceHyperlinkDetector {
        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            Collection<? extends String> targetIds = HyperlinkUtil.getTargetIds(textViewer);
            return targetIds.contains(ArtifactReferenceHyperlinkDetector.HTML_TARGET_ID) && !targetIds.contains(ArtifactReferenceHyperlinkDetector.XML_TARGET_ID) ? this.doDetectHyperlinks(textViewer, region, canShowMultipleHyperlinks) : null;
        }
    }

    public static class XMLDetector
    extends ArtifactReferenceHyperlinkDetector {
        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            Collection<? extends String> targetIds = HyperlinkUtil.getTargetIds(textViewer);
            return targetIds.contains(ArtifactReferenceHyperlinkDetector.XML_TARGET_ID) ? this.doDetectHyperlinks(textViewer, region, canShowMultipleHyperlinks) : null;
        }
    }
}

