/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.artifact.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactIconProvider;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactReferenceTextProvider;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactTextProvider;
import oracle.eclipse.tools.common.ui.util.ImageUtil;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;

public class ArtifactLabelProviderExtensionReader {
    private static final String ARTIFACT_EXT_PT = "oracle.eclipse.tools.common.services.ui.artifactLabelProvider";
    private static final Map<String, ArtifactLabel> sARTIFACT_LABELS;
    private static final Map<String, ArtifactCategoryLabel> sCATEGORY_LABELS;
    private static final Map<String, ArtifactFilterLabel> sFILTER_LABELS;
    private static final Map<String, ArtifactReferenceLabel> sREFERENCE_LABELS;
    private static final String TYPE_ID = "type-id";
    private static final String FILTER_ID = "filter-id";
    private static final String ARTIFACT_TYPE = "artifact-type";
    private static final String ARTIFACT_CATEGORY = "artifact-category";
    private static final String ARTIFACT_FILTER = "artifact-filter";
    private static final String ARTIFACT_REFERENCE = "artifact-reference";

    static {
        LinkedHashMap<String, ArtifactLabel> labels = new LinkedHashMap<String, ArtifactLabel>();
        LinkedHashMap<String, ArtifactCategoryLabel> cLabels = new LinkedHashMap<String, ArtifactCategoryLabel>();
        LinkedHashMap<String, ArtifactFilterLabel> fLabels = new LinkedHashMap<String, ArtifactFilterLabel>();
        LinkedHashMap<String, ArtifactReferenceLabel> rLabels = new LinkedHashMap<String, ArtifactReferenceLabel>();
        try {
            IConfigurationElement[] configElems;
            IConfigurationElement[] iConfigurationElementArray = configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(ARTIFACT_EXT_PT);
            int n = configElems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElem = iConfigurationElementArray[n2];
                String configElemName = configElem.getName();
                try {
                    if (configElemName.equals(ARTIFACT_TYPE)) {
                        String artifactType = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)TYPE_ID);
                        labels.put(artifactType, new ArtifactLabel(configElem));
                    } else if (configElemName.equals(ARTIFACT_CATEGORY)) {
                        String categoryType = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)TYPE_ID);
                        cLabels.put(categoryType, new ArtifactCategoryLabel(configElem));
                    } else if (configElemName.equals(ARTIFACT_FILTER)) {
                        String filterID = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)FILTER_ID);
                        fLabels.put(filterID, new ArtifactFilterLabel(configElem));
                    } else if (configElemName.equals(ARTIFACT_REFERENCE)) {
                        String refType = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)TYPE_ID);
                        rLabels.put(refType, new ArtifactReferenceLabel(configElem));
                    }
                }
                catch (PluginUtil.InvalidExtensionException ie) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)ie);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)ce);
        }
        sARTIFACT_LABELS = Collections.unmodifiableMap(labels);
        sCATEGORY_LABELS = Collections.unmodifiableMap(cLabels);
        sFILTER_LABELS = Collections.unmodifiableMap(fLabels);
        sREFERENCE_LABELS = Collections.unmodifiableMap(rLabels);
    }

    public static Map<String, ArtifactLabel> getArtifactLabels() {
        return sARTIFACT_LABELS;
    }

    public static Map<String, ArtifactCategoryLabel> getCategoryLabels() {
        return sCATEGORY_LABELS;
    }

    public static Map<String, ArtifactFilterLabel> getFilterLabels() {
        return sFILTER_LABELS;
    }

    public static Map<String, ArtifactReferenceLabel> getReferenceLabels() {
        return sREFERENCE_LABELS;
    }

    public static class ArtifactCategoryLabel {
        private final String label;
        private final Image image;

        public ArtifactCategoryLabel(IConfigurationElement category) throws CoreException, PluginUtil.InvalidExtensionException {
            this.label = PluginUtil.findRequiredAttribute((IConfigurationElement)category, (String)"label");
            this.image = ImageUtil.getImageFromPlugin((String)"icon-path", (IConfigurationElement)category);
        }

        public String getLabel() {
            return this.label;
        }

        public Image getImage() {
            return this.image;
        }
    }

    public static class ArtifactFilterLabel {
        private final String label;
        private final String desc;
        private final Image image;

        public ArtifactFilterLabel(IConfigurationElement category) throws PluginUtil.InvalidExtensionException {
            this.label = PluginUtil.findRequiredAttribute((IConfigurationElement)category, (String)"label");
            this.desc = category.getAttribute("description");
            this.image = ImageUtil.getImageFromPlugin((String)"icon-path", (IConfigurationElement)category);
        }

        public String getLabel() {
            return this.label;
        }

        public Image getImage() {
            return this.image;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    public static class ArtifactLabel {
        private final String label;
        private final ArtifactTextProvider labelTextProvider;
        private final String desc;
        private final ArtifactTextProvider descTextProvider;
        private final Image image;
        private final ArtifactIconProvider iconProvider;

        public ArtifactLabel(IConfigurationElement artifact) throws CoreException, PluginUtil.InvalidExtensionException {
            IConfigurationElement textProviderElem;
            IConfigurationElement iconElem = PluginUtil.findRequiredElement((IConfigurationElement)artifact, (String)"icon");
            IConfigurationElement labelElem = PluginUtil.findRequiredElement((IConfigurationElement)artifact, (String)"label");
            IConfigurationElement descElem = PluginUtil.findRequiredElement((IConfigurationElement)artifact, (String)"description");
            if (iconElem.getChildren("icon-path").length > 0) {
                IConfigurationElement imageElem = PluginUtil.findRequiredElement((IConfigurationElement)iconElem, (String)"icon-path");
                this.image = ImageUtil.getImageFromPlugin(null, (IConfigurationElement)imageElem);
                this.iconProvider = null;
            } else {
                this.image = null;
                IConfigurationElement iconProviderElem = PluginUtil.findRequiredElement((IConfigurationElement)iconElem, (String)"icon-provider");
                this.iconProvider = (ArtifactIconProvider)iconProviderElem.createExecutableExtension("provider-class");
            }
            if (labelElem.getChildren("text").length > 0) {
                this.label = PluginUtil.findRequiredElement((IConfigurationElement)labelElem, (String)"text").getValue();
                this.labelTextProvider = null;
            } else {
                textProviderElem = PluginUtil.findRequiredElement((IConfigurationElement)labelElem, (String)"text-provider");
                this.label = textProviderElem.getAttribute("format-string");
                this.labelTextProvider = (ArtifactTextProvider)textProviderElem.createExecutableExtension("provider-class");
            }
            if (descElem.getChildren("text").length > 0) {
                this.desc = PluginUtil.findRequiredElement((IConfigurationElement)descElem, (String)"text").getValue();
                this.descTextProvider = null;
            } else {
                textProviderElem = PluginUtil.findRequiredElement((IConfigurationElement)descElem, (String)"text-provider");
                this.desc = textProviderElem.getAttribute("format-string");
                this.descTextProvider = (ArtifactTextProvider)textProviderElem.createExecutableExtension("provider-class");
            }
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.desc;
        }

        public Image getImage() {
            return this.image;
        }

        public ArtifactTextProvider getLabelTextProvider() {
            return this.labelTextProvider;
        }

        public ArtifactTextProvider getDescriptionTextProvider() {
            return this.descTextProvider;
        }

        public ArtifactIconProvider getIconProvider() {
            return this.iconProvider;
        }
    }

    public static class ArtifactReferenceLabel {
        private final String label;
        private final ArtifactReferenceTextProvider labelTextProvider;
        private final Image image;

        public ArtifactReferenceLabel(IConfigurationElement artifactReference) throws CoreException, PluginUtil.InvalidExtensionException {
            IConfigurationElement labelElem = PluginUtil.findRequiredElement((IConfigurationElement)artifactReference, (String)"reference-label");
            this.image = ImageUtil.getImageFromPlugin((String)"icon-path", (IConfigurationElement)artifactReference);
            if (labelElem.getChildren("text").length > 0) {
                this.label = PluginUtil.findRequiredElement((IConfigurationElement)labelElem, (String)"text").getValue();
                this.labelTextProvider = null;
            } else {
                IConfigurationElement textProviderElem = PluginUtil.findRequiredElement((IConfigurationElement)labelElem, (String)"reference-text-provider");
                this.label = textProviderElem.getAttribute("format-string");
                this.labelTextProvider = (ArtifactReferenceTextProvider)textProviderElem.createExecutableExtension("provider-class");
            }
        }

        public String getLabel() {
            return this.label;
        }

        public Image getImage() {
            return this.image;
        }

        public ArtifactReferenceTextProvider getLabelTextProvider() {
            return this.labelTextProvider;
        }
    }
}

