/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.artifact.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IActionDelegate;

public class ArtifactActionProviderExtensionReader {
    private static final String EXT_PT_ID = "oracle.eclipse.tools.common.services.ui.artifactActionProvider";
    private static final String ARTIFACT_TYPE = "artifact-type";
    private static final String TYPE_ID = "type-id";
    private static final String OPEN_ACTION = "open-action";
    private static final String DELETE_ACTION = "delete-action";
    private static final String CLASS = "class";
    private static final Map<String, IActionDelegate> OPEN_ACTION_DELEGATES;
    private static final Map<String, IActionDelegate> DELETE_ACTION_DELEGATES;

    static {
        IConfigurationElement[] configElems;
        LinkedHashMap<String, IActionDelegate> openActionDelegates = new LinkedHashMap<String, IActionDelegate>();
        LinkedHashMap<String, IActionDelegate> deleteActionDelegates = new LinkedHashMap<String, IActionDelegate>();
        IConfigurationElement[] iConfigurationElementArray = configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT_ID);
        int n = configElems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElem = iConfigurationElementArray[n2];
            String configElemName = configElem.getName();
            try {
                if (configElemName.equals(ARTIFACT_TYPE)) {
                    Object deleteActionDelegate;
                    IConfigurationElement deleteActionElem;
                    Object openActionDelegate;
                    String typeID = PluginUtil.findRequiredAttribute((IConfigurationElement)configElem, (String)TYPE_ID);
                    IConfigurationElement openActionElem = PluginUtil.findOptionalElement((IConfigurationElement)configElem, (String)OPEN_ACTION);
                    if (openActionElem != null && (openActionDelegate = openActionElem.createExecutableExtension(CLASS)) instanceof IActionDelegate) {
                        openActionDelegates.put(typeID, (IActionDelegate)openActionDelegate);
                    }
                    if ((deleteActionElem = PluginUtil.findOptionalElement((IConfigurationElement)configElem, (String)DELETE_ACTION)) != null && (deleteActionDelegate = deleteActionElem.createExecutableExtension(CLASS)) instanceof IActionDelegate) {
                        deleteActionDelegates.put(typeID, (IActionDelegate)deleteActionDelegate);
                    }
                }
            }
            catch (PluginUtil.InvalidExtensionException ie) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)ie);
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)ce);
            }
            ++n2;
        }
        OPEN_ACTION_DELEGATES = Collections.unmodifiableMap(openActionDelegates);
        DELETE_ACTION_DELEGATES = Collections.unmodifiableMap(deleteActionDelegates);
    }

    public static Map<String, IActionDelegate> getOpenActionDelegates() {
        return OPEN_ACTION_DELEGATES;
    }

    public static Map<String, IActionDelegate> getDeleteActionDelegates() {
        return DELETE_ACTION_DELEGATES;
    }
}

