/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactCategoryManager;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.ui.dependency.Messages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class ArtifactNavigationContentProvider
implements ITreeContentProvider,
IDependencyModelListener {
    private final ArtifactController controller = ArtifactControllerFactory.getController();
    private Viewer viewer = null;

    public ArtifactNavigationContentProvider() {
        this.controller.addListener((IDependencyModelListener)this);
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ProjectScopeArtifactCategory) {
            HashSet<ProjectScopeArtifactCategory> children = new HashSet<ProjectScopeArtifactCategory>();
            ProjectScopeArtifactCategory scopedCategory = (ProjectScopeArtifactCategory)parent;
            IProject project = scopedCategory.getProject();
            Set cats = scopedCategory.getArtifactCategory().getChildCategories();
            if (cats != null && project != null) {
                for (IArtifactCategory cat : cats) {
                    try {
                        if (!cat.isEnabledFor(project)) continue;
                        children.add(ProjectScopeArtifactCategory.SCOPE(cat, project));
                    }
                    catch (CoreException ce) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)ce);
                    }
                }
            }
            children.addAll(this.controller.getAllArtifactsInCategory(scopedCategory.getArtifactCategory(), project));
            return children.toArray();
        }
        if (parent instanceof IArtifact) {
            LinkedHashSet<ProjectScopeArtifactCategory> children = new LinkedHashSet<ProjectScopeArtifactCategory>();
            IArtifact artifact = (IArtifact)parent;
            Set cats = this.controller.getChildCategories(artifact);
            for (IArtifactCategory cat : cats) {
                try {
                    IProject project = artifact.getProject();
                    if (project == null || !cat.isEnabledFor(project)) continue;
                    children.add(ProjectScopeArtifactCategory.SCOPE(cat, project));
                }
                catch (CoreException ce) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)ce);
                }
            }
            Set childArtifacts = this.controller.getArtifactChildren(artifact);
            for (IArtifact child : childArtifacts) {
                if (this.controller.getCategoryFor(child) != null) continue;
                children.add((ProjectScopeArtifactCategory)child);
            }
            return children.toArray();
        }
        IProject project = this.getProject(parent);
        if (project != null) {
            return this.getChildren(ProjectScopeArtifactCategory.SCOPE(ArtifactCategoryManager.categoryFor((String)"ROOT"), project));
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        IArtifactCategory parentCat;
        IArtifactCategory cat;
        if (object instanceof IArtifactCategory && (cat = (IArtifactCategory)object).getParentType() != IArtifactCategory.PARENT_TYPE.ARTIFACT) {
            return cat.getParentCategory();
        }
        if (object instanceof IArtifact && (parentCat = this.controller.getCategoryFor((IArtifact)object)) != null) {
            return parentCat;
        }
        return new Object[0];
    }

    public void dispose() {
        this.controller.removeListener((IDependencyModelListener)this);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
    }

    private IProject getProject(Object element) {
        IProject aProject = null;
        if (element instanceof IProject) {
            aProject = (IProject)element;
        } else if (element instanceof IAdaptable) {
            aProject = (IProject)Platform.getAdapterManager().loadAdapter(element, IProject.class.getName());
        }
        return aProject;
    }

    public void modelChanged(DependencyModelEvent event) {
        switch (event.getType()) {
            case UPDATED: 
            case REFRESHED: {
                this.refresh();
            }
        }
    }

    public void projectClosed(IProject project) {
        this.refresh();
    }

    private void refresh() {
        final IWorkspaceRoot element = ResourcesPlugin.getWorkspace().getRoot();
        if (this.viewer instanceof AbstractTreeViewer) {
            if (Display.getCurrent() != null) {
                ((AbstractTreeViewer)this.viewer).refresh((Object)element, true);
            } else {
                UIJob job = new UIJob(Messages.ArtifactNavigationContentProvider_jobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (ArtifactNavigationContentProvider.this.viewer.getControl() != null && ArtifactNavigationContentProvider.this.viewer.getControl().isDisposed()) {
                            return Status.OK_STATUS;
                        }
                        ((AbstractTreeViewer)ArtifactNavigationContentProvider.this.viewer).refresh(element, true);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public static interface IProjectScopeArtifactCategory {
        public IProject getProject();
    }

    private static class ProjectScopeArtifactCategory
    implements IArtifactCategory,
    IProjectScopeArtifactCategory,
    IAdaptable {
        private static final Map<IProject, Map<String, ProjectScopeArtifactCategory>> scopedCategories = new HashMap<IProject, Map<String, ProjectScopeArtifactCategory>>();
        private final IArtifactCategory cat;
        private final IProject project;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ProjectScopeArtifactCategory SCOPE(IArtifactCategory cat, IProject prj) {
            Map<IProject, Map<String, ProjectScopeArtifactCategory>> map = scopedCategories;
            synchronized (map) {
                ProjectScopeArtifactCategory scopedCat;
                Map<String, ProjectScopeArtifactCategory> cats = scopedCategories.get(prj);
                if (cats == null) {
                    cats = new HashMap<String, ProjectScopeArtifactCategory>(10);
                    scopedCategories.put(prj, cats);
                }
                if ((scopedCat = cats.get(cat.getCategoryId())) == null) {
                    scopedCat = new ProjectScopeArtifactCategory(cat, prj);
                    cats.put(cat.getCategoryId(), scopedCat);
                }
                return scopedCat;
            }
        }

        private ProjectScopeArtifactCategory(IArtifactCategory cat, IProject prj) {
            this.project = prj;
            this.cat = cat;
        }

        @Override
        public IProject getProject() {
            return this.project;
        }

        public IArtifactCategory getArtifactCategory() {
            return this.cat;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(IArtifactCategory.class)) {
                return this.getArtifactCategory();
            }
            return null;
        }

        public String toString() {
            return this.cat == null ? "" : this.cat.toString();
        }

        public String getCategoryId() {
            return this.cat == null ? null : this.cat.getCategoryId();
        }

        public Set<IArtifactCategory> getChildCategories() {
            return this.cat == null ? null : this.cat.getChildCategories();
        }

        public Set<String> getIncludedTypes() {
            return this.cat == null ? null : this.cat.getIncludedTypes();
        }

        public String getParentArtifactType() throws IllegalStateException {
            return this.cat == null ? null : this.cat.getParentArtifactType();
        }

        public IArtifactCategory getParentCategory() throws IllegalStateException {
            return this.cat == null ? null : this.cat.getParentCategory();
        }

        public IArtifactCategory.PARENT_TYPE getParentType() {
            return this.cat == null ? null : this.cat.getParentType();
        }

        public boolean isEnabledFor(IProject prj) throws CoreException {
            return this.cat == null ? false : this.cat.isEnabledFor(prj);
        }
    }
}

