/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency;

import java.util.Map;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactTypeFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactCategory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactIconProvider;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactReferenceTextProvider;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactTextProvider;
import oracle.eclipse.tools.common.services.ui.dependency.artifact.internal.ArtifactLabelProviderExtensionReader;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class ArtifactLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    private final Map<String, ArtifactLabelProviderExtensionReader.ArtifactLabel> labels = ArtifactLabelProviderExtensionReader.getArtifactLabels();
    private final Map<String, ArtifactLabelProviderExtensionReader.ArtifactCategoryLabel> cLabels = ArtifactLabelProviderExtensionReader.getCategoryLabels();
    private final Map<String, ArtifactLabelProviderExtensionReader.ArtifactFilterLabel> fLabels = ArtifactLabelProviderExtensionReader.getFilterLabels();
    private final Map<String, ArtifactLabelProviderExtensionReader.ArtifactReferenceLabel> rLabels = ArtifactLabelProviderExtensionReader.getReferenceLabels();

    public Image getImage(Object element) {
        Object newElement = this.adaptToKnownType(element);
        if (newElement instanceof IArtifact) {
            ArtifactLabelProviderExtensionReader.ArtifactLabel label = this.labels.get(((IArtifact)newElement).getType());
            if (label == null) {
                return null;
            }
            ArtifactIconProvider iconProvider = label.getIconProvider();
            if (iconProvider != null) {
                return iconProvider.getImage((IArtifact)newElement);
            }
            return label.getImage();
        }
        if (newElement instanceof IArtifactCategory) {
            ArtifactLabelProviderExtensionReader.ArtifactCategoryLabel label = this.cLabels.get(((IArtifactCategory)newElement).getCategoryId());
            return label == null ? null : label.getImage();
        }
        if (newElement instanceof ArtifactTypeFilter) {
            ArtifactLabelProviderExtensionReader.ArtifactFilterLabel label = this.fLabels.get(((ArtifactTypeFilter)newElement).getId());
            return label == null ? null : label.getImage();
        }
        return null;
    }

    public String getText(Object element) {
        Object newElement = this.adaptToKnownType(element);
        if (newElement instanceof IArtifact) {
            ArtifactLabelProviderExtensionReader.ArtifactLabel label = this.labels.get(((IArtifact)newElement).getType());
            if (label == null) {
                return null;
            }
            ArtifactTextProvider textProvider = label.getLabelTextProvider();
            if (textProvider != null) {
                return textProvider.getText((IArtifact)newElement, label.getLabel());
            }
            return label.getLabel();
        }
        if (newElement instanceof IArtifactCategory) {
            ArtifactLabelProviderExtensionReader.ArtifactCategoryLabel label = this.cLabels.get(((IArtifactCategory)newElement).getCategoryId());
            return label == null ? null : label.getLabel();
        }
        if (newElement instanceof ArtifactTypeFilter) {
            ArtifactLabelProviderExtensionReader.ArtifactFilterLabel label = this.fLabels.get(((ArtifactTypeFilter)newElement).getId());
            return label == null ? null : label.getLabel();
        }
        if (newElement instanceof IArtifactReference) {
            ArtifactLabelProviderExtensionReader.ArtifactReferenceLabel label = this.rLabels.get(((IArtifactReference)newElement).getType());
            if (label == null) {
                return null;
            }
            ArtifactReferenceTextProvider textProvider = label.getLabelTextProvider();
            if (textProvider != null) {
                return textProvider.getText((IArtifactReference)newElement, label.getLabel());
            }
            return label.getLabel();
        }
        return null;
    }

    public String getDescriptionText(IArtifact artifact) {
        ArtifactLabelProviderExtensionReader.ArtifactLabel label = this.labels.get(artifact.getType());
        if (label == null) {
            return null;
        }
        ArtifactTextProvider textProvider = label.getDescriptionTextProvider();
        if (textProvider != null) {
            return textProvider.getText(artifact, label.getDescription());
        }
        return label.getDescription();
    }

    private Object adaptToKnownType(Object element) {
        if (element instanceof IResource) {
            return element;
        }
        if (!(element instanceof IArtifact) && !(element instanceof IArtifactCategory) && !(element instanceof ArtifactTypeFilter) && element instanceof IAdaptable) {
            Object adaptedElement = ((IAdaptable)element).getAdapter(IArtifact.class);
            if (adaptedElement == null && (adaptedElement = ((IAdaptable)element).getAdapter(IArtifactCategory.class)) == null) {
                adaptedElement = ((IAdaptable)element).getAdapter(ArtifactTypeFilter.class);
            }
            if (adaptedElement != null) {
                return adaptedElement;
            }
        }
        return element;
    }
}

