/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.classpath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.classpath.OepeClasspathContainerFactoryRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class OepeClasspathConfigPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension,
IClasspathContainerPageExtension2 {
    private static final String ORACLE_ECLIPSE_TOOLS_ADFESSENTIALS_LIBRARIES = "oracle.eclipse.tools.adfessentials.libraries";
    private Set<String> oldInstallList = new HashSet<String>();
    private List<IClasspathEntry> containerEntries = new ArrayList<IClasspathEntry>();
    private CheckboxTableViewer containersList;

    public OepeClasspathConfigPage() {
        super("AdfEssentialsCoreCPPage");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new FillLayout());
        this.containersList = CheckboxTableViewer.newCheckList((Composite)composite, (int)0);
        this.containersList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.containersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String description = OepeClasspathContainerFactoryRegistry.INSTANCE.getDescription((String)element);
                    return description != null ? description : String.format("Missing id %s", element);
                }
                return String.format("Invalid element type: %s [%s]", element != null ? element.toString() : "*Null*", element != null ? element.getClass().toString() : "null");
            }
        });
        this.containersList.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof String) {
                    String id = (String)element;
                    return OepeClasspathConfigPage.this.oldInstallList.contains(id);
                }
                return false;
            }
        });
        this.containersList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ICheckable checkable = event.getCheckable();
                if (!event.getChecked() && OepeClasspathConfigPage.this.oldInstallList.contains(event.getElement())) {
                    checkable.setChecked(event.getElement(), true);
                }
            }
        });
        this.containersList.setInput((Object)OepeClasspathContainerFactoryRegistry.INSTANCE.getFactories().toArray());
        this.setControl((Control)composite);
    }

    public boolean finish() {
        Object[] objectArray = this.containersList.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedIds = objectArray[n2];
            IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)OepeClasspathConfigPage.createCPPath(checkedIds));
            if (newContainerEntry != null) {
                this.containerEntries.add(newContainerEntry);
            }
            ++n2;
        }
        return true;
    }

    private static IPath createCPPath(Object checkedIds) {
        return new Path(ORACLE_ECLIPSE_TOOLS_ADFESSENTIALS_LIBRARIES).append(checkedIds.toString());
    }

    public IClasspathEntry getSelection() {
        return null;
    }

    public void setSelection(IClasspathEntry containerEntry) {
    }

    public IClasspathEntry[] getNewContainers() {
        return this.containerEntries.toArray(new IClasspathEntry[this.containerEntries.size()]);
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        List factories = OepeClasspathContainerFactoryRegistry.INSTANCE.getFactories();
        IClasspathEntry[] iClasspathEntryArray = currentEntries;
        int n = currentEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5) {
                String ns = entry.getPath().segment(0);
                String id = entry.getPath().segment(1);
                if (ORACLE_ECLIPSE_TOOLS_ADFESSENTIALS_LIBRARIES.equals(ns) && factories.contains(id)) {
                    this.oldInstallList.add(id);
                }
            }
            ++n2;
        }
    }
}

