/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.appgen.utils;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerator;
import oracle.eclipse.tools.common.services.appgen.refactoring.GenerationRefactoring;
import oracle.eclipse.tools.common.services.appgen.refactoring.GenerationRefactoringProcessor;
import oracle.eclipse.tools.common.services.appgen.refactoring.IResourceChangeFactory;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.appgen.Messages;
import oracle.eclipse.tools.common.services.ui.appgen.refactoring.GenerationRefactoringWizard;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GenerationActionUtil {
    public static IStatus runWithDialog(IGenerator generator) {
        Shell parent = Activator.getShell();
        return GenerationActionUtil.runWithDialog(generator, parent);
    }

    public static IStatus runWithDialog(IGenerator generator, Shell parent) {
        int opStatus;
        if (generator == null) {
            String message = "Program Error: IGenerator is null";
            IllegalArgumentException iae = new IllegalArgumentException(message);
            LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)iae);
            return new Status(4, "oracle.eclipse.tools.common.services.ui", message, (Throwable)iae);
        }
        GenerationRefactoringProcessor processor = new GenerationRefactoringProcessor(generator, (IResourceChangeFactory)new ResourceChangeFactory());
        GenerationRefactoring refactoring = new GenerationRefactoring(processor);
        GenerationRefactoringWizard wizard = new GenerationRefactoringWizard((Refactoring)refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            opStatus = operation.run(parent, Messages.ServiceGenerationRefactoringWizard_dialog_title);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        if (opStatus == 1025) {
            return new Status(4, "oracle.eclipse.tools.common.services.ui", Messages.ServiceGenerationRefactoring_failed);
        }
        if (opStatus == 1) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static IStatus run(IGenerator generator, IProgressMonitor monitor) {
        if (generator == null) {
            String message = "Program Error: IGenerator is null";
            IllegalArgumentException iae = new IllegalArgumentException(message);
            LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)iae);
            return new Status(4, "oracle.eclipse.tools.common.services.ui", message, (Throwable)iae);
        }
        GenerationRefactoringProcessor processor = new GenerationRefactoringProcessor(generator, (IResourceChangeFactory)new ResourceChangeFactory());
        GenerationRefactoring refactoring = new GenerationRefactoring(processor);
        final PerformRefactoringOperation refactorOp = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                refactorOp.run(pm);
            }
        };
        if (monitor != null) {
            try {
                ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
            }
            catch (CoreException ce) {
                return ce.getStatus();
            }
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, pm);
                }
                catch (CoreException ce) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)ce);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnableWithProgress);
        }
        catch (InvocationTargetException ite) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)ite);
            return new Status(4, "oracle.eclipse.tools.common.services.ui", Messages.ServiceGenerationRefactoring_failed, (Throwable)ite);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        RefactoringStatus refactoringStatus = refactorOp.getValidationStatus();
        if (refactoringStatus != null && refactoringStatus.hasError()) {
            return new Status(4, "oracle.eclipse.tools.common.services.ui", Messages.ServiceGenerationRefactoring_failed);
        }
        return Status.OK_STATUS;
    }

    public static class MyCreateTextFileChange
    extends CreateTextFileChange {
        private final IFile _file;

        public MyCreateTextFileChange(IFile file, String source, String encoding, String textType) {
            super(file.getFullPath(), source, encoding, textType);
            this._file = file;
        }

        public Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            this.ensurePathToNewResource(pm);
            return super.perform(pm);
        }

        private void ensurePathToNewResource(IProgressMonitor pm) throws CoreException {
            IContainer container = this._file.getParent();
            if (container.getType() == 2) {
                FolderUtil.ensureFolder((IFolder)((IFolder)container), (IProgressMonitor)pm);
            }
        }
    }

    public static class ResourceChangeFactory
    implements IResourceChangeFactory {
        public ResourceChange getCreateTextFileChange(IFile file, String source, String encoding, String textType) {
            return new MyCreateTextFileChange(file, source, encoding, textType);
        }
    }
}

