/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui;

import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.ui.dependency.prefs.DependencyCanceledListener;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.common.services.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DependencyModelManager.getInstance().getModel().addListener((IDependencyModelListener)new DependencyCanceledListener());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images[] imagesArray = Images.values();
        int n = imagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Images img = imagesArray[n2];
            img.init(reg);
            ++n2;
        }
    }

    public static Shell getShell() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void log(String msg, Throwable t) {
        ILog log;
        Activator activator = Activator.getDefault();
        if (activator != null && (log = activator.getLog()) != null) {
            log.log((IStatus)new Status(4, PLUGIN_ID, msg, t));
            return;
        }
        t.printStackTrace();
    }

    public static enum Images {
        GENERIC_ARTIFACT("images/generic.gif"),
        LINK_IMAGE("images/dependency/link_obj.gif"),
        PLUS_ICON_IMAGE("images/dependency/expand.png"),
        MINUS_ICON_IMAGE("images/dependency/collapse.png"),
        FILTER_DEPENDENCIES_IMAGE("images/dependency/filter.png"),
        FILTER_DEPENDENCIES_HOVER_IMAGE("images/dependency/filter-hover.png"),
        HEADER_BKGND_CENTER_IMAGE("images/dependency/header_mid_bg.png"),
        HEADER_BKGND_LEFT_IMAGE("images/dependency/header_left_bg.png"),
        HEADER_BKGND_RIGHT_IMAGE("images/dependency/header_right_bg.png"),
        CHECKED_TABLE("images/icons/checked_table.gif"),
        CHECKED_TABLE_DISABLED("images/icons/checked_table_disabled.gif"),
        UNCHECKED_TABLE("images/icons/unchecked_table.gif"),
        UNCHECKED_TABLE_DISABLED("images/icons/unchecked_table_disabled.gif");

        private String _key;

        private Images(String path) {
            this._key = path;
        }

        private void init(ImageRegistry reg) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)Activator.PLUGIN_ID, (String)this._key);
            reg.put(this._key, desc);
        }

        public Image getImage() {
            return Activator.getDefault().getImageRegistry().get(this._key);
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.getDefault().getImageRegistry().getDescriptor(this._key);
        }
    }
}

