/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.operations;

import com.google.gerrit.common.data.ReviewerResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;

public class AddReviewersRequest
extends AbstractRequest<ReviewerResult> {
    private final List<String> reviewers;
    private final String reviewId;

    public AddReviewersRequest(String reviewId, List<String> reviewers) {
        Assert.isNotNull((Object)reviewId);
        Assert.isNotNull(reviewers);
        this.reviewId = reviewId;
        this.reviewers = Collections.unmodifiableList(new ArrayList<String>(reviewers));
    }

    public List<String> getReviewers() {
        return this.reviewers;
    }

    public String getReviewId() {
        return this.reviewId;
    }

    @Override
    protected ReviewerResult execute(GerritClient client, IProgressMonitor monitor) throws GerritException {
        return client.addReviewers(this.getReviewId(), this.getReviewers(), monitor);
    }
}

