'''
Created Summer, 2015

@author: kvlinden
'''
from fraction import Fraction
import unittest


class Test(unittest.TestCase):


    def test_constructor(self):
        try:
            f = Fraction()
            assert f.get_numerator() == 0
            assert f.get_denominator() == 1
            
            f = Fraction(1, 2)
            assert f.__str__() == '1/2'
            
            Fraction(1.0, -2.0)
            
        except:
            self.fail('This should not raise any exceptions.')
        
    def test_exceptions(self):
        try:
            Fraction(1, 0)
            self.fail('This should raise an exception')
        except ValueError:
            pass
        except:
            self.fail('This should raise a ValueError exception.')

        try:
            f = Fraction()
            f.set_denominator(0)
            self.fail('This should raise an exception')
        except ValueError:
            pass
        except:
            self.fail('This should raise a ValueError exception.')


if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.testName']
    unittest.main()