'''
The old Fraction class, updated with exception handling...

Created Summer, 2015

@author: kvlinden
'''

import sys

def computeGCD(alpha, beta):
    '''
    (int, int) -> int
    This function finds the greatest common divisor of two integers, using
    Euclid&rsquo;s algorithm
    '''
    alpha = abs(alpha)
    beta = abs(beta)
    remainder = alpha % beta
    while (remainder != 0):
        alpha = beta
        beta = remainder
        remainder = alpha % beta
    return beta


class Fraction:
    
    def __init__(self, numerator=0, denominator=1):
        if denominator == 0:
            raise ValueError('This is a not a valid denominator')
        else:
            self._numerator = numerator
            self._denominator = denominator
            self._simplify()
    
    def _simplify(self):
        gcd = computeGCD(self._numerator, self._denominator)
        self._numerator = self._numerator // gcd
        self._denominator = self._denominator // gcd
        if self._denominator < 0:
            self._numerator = self._numerator * -1
            self._denominator = self._denominator * -1
            
    def get_numerator(self):        
        return self._numerator
    
    def get_denominator(self):
        return self._denominator
    
    def set_numerator(self, numerator):
        self._numerator = numerator
        self._simplify()
    
    def set_denominator(self, denominator):
        if denominator == 0:
            raise ValueError('This is not a valid denominator.')
        self._denominator = denominator
        self._simplify()
    
    def __str__(self):
        return str(self._numerator) + '/' + str(self._denominator)

    def __mul__(self, other):
        return Fraction(self._numerator * other.get_numerator(), \
                        self._denominator * other.get_denominator())

if __name__ == '__main__':
    print(Fraction())
    f1 = Fraction(1, 2)
    f2 = Fraction(2, 3)
    print(f1 * f2)
