"""
This module implements unit tests for the figure class hierarchy.

@author: Keith VanderLinden (kvlinden)
@date: Summer, 2015
@date: Summer, 2021 - ported to GuiZero; cleaned up for new video demo
"""

import math
from figure import *


# Rectangle Tests

rectangle = Rectangle((0, 0), (100, 10))
assert str(rectangle) == 'Rectangle: (0, 0) (100, 10) black True'
assert abs(rectangle.get_area() - 1000.0) < 1e-2
assert rectangle.get_end_point() == (100, 10)

# Empty rectangles are possible and have area 0.0.
assert abs(Rectangle((0, 0), (0, 0)).get_area() - 0.0) < 1e-2

# Test type hierarchy.
assert isinstance(rectangle, Rectangle)
assert isinstance(rectangle, ClosedFigure)
assert isinstance(rectangle, Figure)
assert not isinstance(rectangle, Ellipse)


# Ellipse tests

ellipse = Ellipse((0, 0), (10, 100))
assert str(ellipse) == 'Ellipse: (0, 0) (10, 100) black True'
assert abs(ellipse.get_area() - math.pi * 1000) < 1e-2
assert ellipse.get_end_point() == (10, 100)

# Empty ellipses are possible and have area 0.0.
assert abs(Ellipse((0, 0), (0, 0)).get_area() - 0.0) < 1e-2

# Test type hierarchy.
assert isinstance(ellipse, Ellipse)
assert isinstance(ellipse, ClosedFigure)
assert isinstance(ellipse, Figure)
assert not isinstance(ellipse, Rectangle)


# Line Tests

line = Line((0, 0), (0, 10))
assert str(line) == 'Line: (0, 0) (0, 10) black'
assert abs(line.get_length() - 10.0) < 1e-2

# Zero-length lines are possible.
assert abs(Line((0, 0), (0, 0)).get_length() - 0.0) < 1e-2

# Test type hierarchy.
assert isinstance(line, Line)
assert isinstance(line, Figure)
assert not isinstance(line, Rectangle)


# Squiggle Tests

squiggle = Squiggle((0, 0))
for x in range(1, 5):
    squiggle.add_point((0, x))
assert str(squiggle) == 'Squiggle: [(0, 0), (0, 1), (0, 2), (0, 3), (0, 4)] black'
assert abs(squiggle.get_length() - 4.0) < 1e-2

# Zero-length squiggles are possible.
assert abs(Squiggle((0, 0)).get_length() - 0.0) < 1e-2

# Multiple-point, zero-length squiggles are also possible.
squiggle = Squiggle((0, 0))
for n in range(5):
    squiggle.add_point((0, 0))
assert abs(squiggle.get_length() - 0.0) < 1e-2

# Test type hierarchy.
assert isinstance(squiggle, Squiggle)
assert isinstance(squiggle, Figure)
assert not isinstance(squiggle, Line)
