"""
Draw an image on the canvas or on a logo.
This module implements an experimental animation based on elapsed time;
    it would be easier to animate the image based on presumed movement
    (e.g., see lab 12).

@author: kvlinden
@date: Summer, 2016
@date: Spring, 2021 - ported to GuiZero
@author: kcarnold (Spring 2021): updated the location computation
"""

from guizero import App, Drawing, Picture, PushButton
from guizero.utilities import GUIZeroImage
from datetime import datetime

def add_image_to_drawing(drawing, image, x, y, anchor="nw", **kwargs):
    '''
    Draws an image on a canvas at a given location.

    drawing: a GuiZero Drawing widget
    image:   a GUIZeroImage object
    x, y:    coordinates of the top left corner of where to draw the image
    anchor:  defaults to "nw" (northwest); alternatives include "center", "ne", "sw", "se", "e", ...
    '''
    return drawing.tk.create_image(x, y, image=image.tk_image, anchor=anchor, **kwargs)


class MyApp:

    def __init__(self, app):

        app.title = 'Image Demo'
        app.width = 500
        app.height = 500
        app.font = 'Helvetica'
        app.text_size = 12

        self.drawing = Drawing(app, width=app.width, height=app.width)

        # Load the image into memory.
        self.tux_image = GUIZeroImage('tux-128.gif', width=None, height=None)
        
        self.start_time = datetime.now()
        app.repeat(10, self.draw_frame)
        
    def draw_frame(self):
        # Compute the new position based on elapsed time rather than
        # on assumed time.
        seconds_since_start = (datetime.now() - self.start_time).total_seconds()
        t = (seconds_since_start / 3) % 1
        x = (.5 - t) ** 2 * 300
        y = (.5 - t) ** 2 * 500

        self.drawing.clear()
        self.drawing.text(0, 0, f'{t:.2f}')
        add_image_to_drawing(
            drawing=self.drawing,
            image=self.tux_image,
            x=x, y=y
        )

        # You can also show images on buttons and widgets like this
        #PushButton(app, image='tux-128.gif')
        #Picture(app, image='tux-128.gif')


# Create the GuiZero application.
app = App()
my_app = MyApp(app)
app.display()
