"""
Draw an image on the canvas or on a logo.

@author: kvlinden
@date: Summer, 2016
@date: Spring, 2021 - ported to GuiZero
@author: kcarnold (Spring 2021): store the image in memory, to avoid reloading constantly from disk in an animation
"""

from guizero import App, Drawing, Picture, PushButton
from guizero.utilities import GUIZeroImage

def add_image_to_drawing(drawing, image, x, y, anchor="nw", **kwargs):
    '''
    Draws an image on a canvas at a given location.

    drawing: a GuiZero Drawing widget
    image:   a GUIZeroImage object
    x, y:    coordinates of the top left corner of where to draw the image
    anchor:  defaults to "nw" (northwest); alternatives include "center", "ne", "sw", "se", "e", ...
    '''
    return drawing.tk.create_image(x, y, image=image.tk_image, anchor=anchor, **kwargs)


class MyApp:

    def __init__(self, app):

        app.title = 'Image Demo'
        app.width = 500
        app.height = 500
        app.font = 'Helvetica'
        app.text_size = 12

        self.drawing = Drawing(app, width=app.width, height=app.width)

        # Load the image into memory.
        self.tux_image = GUIZeroImage('tux-128.gif', width=None, height=None)
        
        self.draw_frame()
        
    def draw_frame(self):
        self.drawing.clear()
        add_image_to_drawing(
            drawing=self.drawing,
            image=self.tux_image,
            x=50, y=100
        )

# You can also show images on buttons and widgets like this
#PushButton(app, image='tux-128.gif')
#Picture(app, image='tux-128.gif')


# Create the GuiZero application.
app = App()
my_app = MyApp(app)
app.display()
