import turtle
import random
from fish import Fish


class Bear:
    kind = 'Bear'

    def __init__(self, world):
        self.turtle = turtle.Turtle()
        self.turtle.up()
        self.turtle.hideturtle()
        self.turtle.shape("Bear.gif")

        self.x = 0
        self.y = 0
        self.world = world

        self.starve_tick = 0
        self.breed_tick = 0

    def appear(self):
        self.turtle.goto(self.x, self.y)
        self.turtle.showturtle()

    def hide(self):
        self.turtle.hideturtle()

    def move(self, new_x, new_y):
        self.world.move_thing(self.x, self.y, new_x, new_y)
        self.x = new_x
        self.y = new_y
        self.turtle.goto(self.x, self.y)

    def live_one_step(self):
        self.breed_tick = self.breed_tick + 1
        if self.breed_tick >= 8:
            self.try_to_breed()

        self.try_to_eat()

        if self.starve_tick == 10:
            self.world.del_thing(self)
        else:
            self.try_to_move()

    def try_to_eat(self):
        adjacent_prey = self.world.get_neighbors_of_kind(self.x, self.y, Fish.kind)

        if len(adjacent_prey) > 0:
            random_prey = adjacent_prey[random.randrange(len(adjacent_prey))]
            prey_x = random_prey.x
            prey_y = random_prey.y

            self.world.del_thing(random_prey)
            self.move(prey_x, prey_y)
            self.starve_tick = 0
        else:
            self.starve_tick = self.starve_tick + 1

    def try_to_breed(self):
        neighbor_locations = self.world.get_neighbor_locations(self.x, self.y)

        rand_loc = random.choice(neighbor_locations)
        next_x = rand_loc[0]
        next_y = rand_loc[1]

        if self.world.is_location_empty(next_x, next_y):
            childThing = Bear(self.world)
            self.world.add_thing(childThing, next_x, next_y)
            self.breed_tick = 0

    def try_to_move(self):
        neighbor_locations = self.world.get_neighbor_locations(self.x, self.y)

        rand_loc = random.choice(neighbor_locations)
        next_x = rand_loc[0]
        next_y = rand_loc[1]

        if self.world.is_location_empty(next_x, next_y):
            self.move(next_x, next_y)
