import random
import json

from bear import Bear
from fish import Fish
from world import World

SHOW = True

# TODO: Seed the RNG

num_starting_bears = 10
num_starting_fish = 10
num_steps_to_simulate = 250
world_width = 50
world_height = 25

world = World(world_width, world_height)
world.draw_grid()

world.screen.tracer(False)
for i in range(num_starting_fish):
    while True:
        x = random.randrange(world.max_x)
        y = random.randrange(world.max_y)
        if world.is_location_empty(x, y):
            break
    new_fish = Fish(world)
    world.add_thing(new_fish, x, y)

for i in range(num_starting_bears):
    while True:
        x = random.randrange(world.max_x)
        y = random.randrange(world.max_y)
        if world.is_location_empty(x, y):
            break
    new_bear = Bear(world)
    world.add_thing(new_bear, x, y)
world.screen.update()

log = []

for i in range(num_steps_to_simulate):
    world.live_one_step()
    if SHOW:
        world.screen.update()

    num_bears = world.count_items(Bear.kind)
    num_fish = world.count_items(Fish.kind)
    if SHOW:
        print(f"Step {i:05d}: {num_bears} bears, {num_fish} fish")
    # Log current counts: step, num_bears, and num_fish.

world.screen.tracer(True)

# TODO: Save the log to a file


world.freeze_world()
